import gym as gym_old
import gymnasium as gym
import numpy as np


class ProcgenEnv(gym.Env):

    def __init__(self,env_name):
        self.env_name = env_name
        self.env = gym_old.make(env_name,distribution_mode='memory',disable_env_checker=True)
        self.action_space = gym.spaces.Discrete(self.env.action_space.n)
        self.observation_space = gym.spaces.Box(low=0, high=1.0, shape=(64,64,3), dtype=np.float32)
    
    def reset(self,seed=None, options=None):
        super().reset(seed=seed)
        if seed is not None:
            self.env = gym_old.make(self.env_name,distribution_mode='memory',disable_env_checker=True,start_level=seed)
        obs=self.env.reset()
        obs=obs/255.0
        return obs,{}

    def step(self, action): 
        obs, reward, done, info = self.env.step(action)
        obs=obs/255.0
        reward=float(reward)
        return obs, reward, done, done, info
    


def create_procgen_env(env_name):
    return ProcgenEnv('procgen:procgen-%s-v0'%env_name)